// $Id: CActionEvent.cpp,v 1.4 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CActionEvent.hpp"
#include <Exceptions/CException.hpp>
using Exponent::Exceptions::CException;
using Exponent::GUI::Events::CActionEvent;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CActionEvent, CCountedObject);

//	===========================================================================
CActionEvent::CActionEvent(IControl *control)
			: m_control(NULL)
			, m_eventType(e_controlChanged)
			, m_shiftIsDown(false)
			, m_altIsDown(false)
			, m_ctrlIsDown(false)
{
	EXPONENT_CLASS_CONSTRUCTION(CActionEvent);
	this->setControl(control);
	this->setModifiers(false, false, false);
	m_eventType = e_controlChanged;
}

//	===========================================================================
CActionEvent::CActionEvent(IControl *control, const CMouseEvent &mouseEvent)
			: m_control(NULL)
			, m_eventType(e_controlChanged)
			, m_shiftIsDown(false)
			, m_altIsDown(false)
			, m_ctrlIsDown(false)
{
	EXPONENT_CLASS_CONSTRUCTION(CActionEvent);
	this->setControl(control);
	this->setModifiers(mouseEvent.isShiftDown(), mouseEvent.isAltDown(), mouseEvent.isCtrlDown());
	m_eventType = e_controlChanged;
}

//	===========================================================================
CActionEvent::~CActionEvent()
{
	EXPONENT_CLASS_DESTRUCTION(CActionEvent);
}

//	===========================================================================
IControl *CActionEvent::getControl() const 
{ 
	return m_control; 
}

//	===========================================================================
CActionEvent::EActionEventType CActionEvent::getEventType() const 
{ 
	return m_eventType; 
}

//	===========================================================================
void CActionEvent::setControl(IControl *control)
{
	if (control == NULL)
	{
		throw CException("Control is NULL", "CActionEvent::CActionEvent(IControl *control)");
	}
	m_control = control;
}

//	===========================================================================
void CActionEvent::setEventType(EActionEventType eventType) 
{ 
	m_eventType = eventType; 
}

//	===========================================================================
void CActionEvent::setModifiers(const bool shift, const bool alt, const bool ctrl)
{
	m_shiftIsDown = shift;
	m_altIsDown   = alt;
	m_ctrlIsDown  = ctrl;
}

//	===========================================================================
bool CActionEvent::isCtrlDown() const 
{ 
	return m_ctrlIsDown; 
}

//	===========================================================================
bool CActionEvent::isShiftDown() const 
{ 
	return m_shiftIsDown; 
}

//	===========================================================================
bool CActionEvent::isAltDown() const 
{ 
	return m_altIsDown; 
}